//------------------------------------------------------------------------------
// File: cmn_msgsystem.cs
// This file is used to initialize the message system and scripts
// Author: Matthew Rudge
//------------------------------------------------------------------------------

////////////////////////////////////////////////////////////////////////////////
//! Builds the message system for client and server
////////////////////////////////////////////////////////////////////////////////
function slgBuildMessageSystem()
{
    // Build the router
   slgBuildMessageRouter();
}

////////////////////////////////////////////////////////////////////////////////
//! Destroys the message system for client and server
////////////////////////////////////////////////////////////////////////////////
function slgDestroyMessageSystem()
{
   // Kill the router
   slgShutdownMessageRouter();
}

////////////////////////////////////////////////////////////////////////////////
//! Sends an object creation message back to the server
//! \param %obj Id of object that was created
//! \param %bPost True for post, false for immediate send
////////////////////////////////////////////////////////////////////////////////
function slgSendObjCreateMsg(%obj, %bPost)
{
   // Send object creation message
   if(isObject(MsgSender) && isObject(%obj)) {
      if(%bPost) {
         MsgSender.postMsg($MSG_SLGOBJCREATE, $MRT_NETWORK, %obj);
      }
      else {
         MsgSender.sendMsg($MSG_SLGOBJCREATE, $MRT_NETWORK, %obj);
      }
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Sends an object creation message locally
//! \param %obj Id of object that was created
////////////////////////////////////////////////////////////////////////////////
function slgSendObjCreateMsgLocal(%obj)
{
    if(isObject(MsgSender) && isObject(%obj)) {
      MsgSender.sendMsg($MSG_SLGOBJCREATE, $MRT_LOCAL, %obj);
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Sends an object destruction message locally
//! \param %obj Id of object that was destroyed
////////////////////////////////////////////////////////////////////////////////
function slgSendObjDestroyMsgLocal(%obj)
{
   // Send object destruction message
   if(isObject(MsgSender) && isObject(%obj)) {
      MsgSender.sendMsg($MSG_SLGOBJDESTROY, $MRT_LOCAL, %obj);
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Sends a tool use message locally
//! \param %toolType Type of tool ($INV_DYNAMITE, etc.)
//! \param %toolUser Tool user
//! \param %bPost True if the message is to be posted
//! \param %toolObj Id of tool object created (optional)
////////////////////////////////////////////////////////////////////////////////
function slgSendToolUseMsgLocal(%toolType, %toolUser, %bPost, %toolObj)
{
   if(isObject(MsgSender)) {
      if(%bPost) {
         MsgSender.postMsg($MSG_TOOLUSE, $MRT_LOCAL, %toolType, %toolUser, %toolObj);
      }
      else {
         MsgSender.sendMsg($MSG_TOOLUSE, $MRT_LOCAL, %toolType, %toolUser, %toolObj);
      }
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Sends a message id of a message to the client to display in the message hud
//! \param %client Client to send to
//! \param %msgId Message id
//! \param %formatId Format string id (optional)
////////////////////////////////////////////////////////////////////////////////
function slgSendHudMessage(%client, %msgId, %formatId)
{
   commandToClient(%client, 'SendHudMessageId', %msgId, %formatId);
}

////////////////////////////////////////////////////////////////////////////////
//! Sends a message id of a message to the client to display in the alert hud
//! \param %client Client to send to
//! \param %msgId Message id
////////////////////////////////////////////////////////////////////////////////
function slgSendAlertMessage(%client, %msgId)
{
   commandToClient(%client, 'SendAlertMessageId', %msgId);
}

// End cmn_msgsystem.cs